﻿<%@ Import Namespace="Soneta.Handel" %>
<%@ Import Namespace="Soneta.Towary" %>
<%@ Import Namespace="Soneta.Magazyny" %>
<%@ Register TagPrefix="ea" Namespace="Soneta.Web" Assembly="Soneta.Web" %>
<%@ Register TagPrefix="eb" Namespace="Soneta.Core.Web" Assembly="Soneta.Core.Web" %>
<%@ Page language="c#" AutoEventWireup="false" codePage="1200" %>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN" >
<HTML>
	<HEAD>
		<TITLE>Sprzedaż wg towarów</TITLE>
		<META content="C#" name="CODE_LANGUAGE">
		<META content="JavaScript" name="vs_defaultClientScript">
		<META content="http://schemas.microsoft.com/intellisense/ie5" name="vs_targetSchema">
		<script runat="server">

SprzedażTowaruWorker stw;

void Grid_ItemsGet(object sender, ItemsGetEventArgs args) {
	if (args.Deep==1) {
		Towar towar = (Towar)args.Row;
		if (stw==null)
			stw = (SprzedażTowaruWorker)
				dc.Context.CreateObject(null, typeof(SprzedażTowaruWorker), towar);
		else
			stw.Towar = towar;
				
		Grid.GroupLine = string.Format("Towar: {0}", towar);
		
		args.Enumerable = stw.PobierzListę();
	}
}

void Grid_BeforeRow(object sender, RowEventArgs args) {
	PozycjaDokHandlowego poz = (PozycjaDokHandlowego)args.Row;
    SumaPozycjiWorker spw = new SumaPozycjiWorker();
    spw.Pozycja = poz;
	switch (poz.KierunekMagazynu) {
		case KierunekPartii.Przychód:
			colZkNetto.EditValue = spw.Netto;
			colZkBrutto.EditValue = spw.Brutto;
			colZkIlosc.EditValue = poz.ZmianaMagazynu.Ilość;
			break;
		case KierunekPartii.Rozchód:
			colSpNetto.EditValue = spw.Netto;
			colSpBrutto.EditValue = spw.Brutto;
			colSpIlosc.EditValue = poz.ZmianaMagazynu.Ilość;
			break;
	}
	if (!poz.ZmianaMagazynu.Ilość.IsZero)
		colCenaJednostki.EditValue = Soneta.Tools.Math.Round(
			(double)spw.Netto/poz.ZmianaMagazynu.Ilość.Value, 
			poz.Towar.Precyzja);
}

		</script>
	</HEAD>
	<BODY>
		<FORM method="post" runat="server">
			<ea:datacontext id="dc" runat="server"></ea:datacontext><eb:reportheader id="ReportHeader" title="Sprzedaż/Zakup wg towarów - szczegóły|Okres: {0}|Magazyny: {1}|Seria: {2}|Definicja: {3}|Typ: {4}"
				runat="server" DataMember4="PozycjeWgTowarówParams.Typ" DataMember3="PozycjeWgTowarówParams.Definicja" DataMember2="PozycjeWgTowarówParams.Seria" DataMember1="PozycjeWgTowarówParams.MagazynyString"
				DataMember0="PozycjeWgTowarówParams.OkresCzasu"></eb:reportheader><ea:grid id="Grid" runat="server" RowTypeName="Soneta.Handel.PozycjaDokHandlowego,Soneta.Handel"
				OnItemsGet="Grid_ItemsGet" OnBeforeRow="Grid_BeforeRow" ShowGroupSum="True">
				<Columns>
					<ea:GridColumn Width="4" Align="Right" DataMember="#" Caption="LP." runat="server" EncodeHTML="True"></ea:GridColumn>
					<ea:GridColumn Width="17" DataMember="Dokument" runat="server" EncodeHTML="True"></ea:GridColumn>
					<ea:GridColumn DataMember="Dokument.Kontrahent" Total="Info" Caption="Kontrahent" EncodeHTML="True" runat="server"></ea:GridColumn>
					<ea:GridColumn Width="10" Align="Right" Total="Sum" Caption="Sprzedaż~Ilość" ID="colSpIlosc" runat="server" EncodeHTML="True"></ea:GridColumn>
					<ea:GridColumn Width="12" Align="Right" Total="Sum" Caption="Sprzedaż~Netto" Format="{0:n}" ID="colSpNetto" runat="server" EncodeHTML="True"></ea:GridColumn>
					<ea:GridColumn Width="12" Align="Right" Total="Sum" Caption="Sprzedaż~Brutto" Format="{0:n}" ID="colSpBrutto" runat="server" EncodeHTML="True"></ea:GridColumn>
					<ea:GridColumn Width="10" Align="Right" Total="Sum" Caption="Zakup~Ilość" ID="colZkIlosc" runat="server" EncodeHTML="True"></ea:GridColumn>
					<ea:GridColumn Width="12" Align="Right" Total="Sum" Caption="Zakup~Netto" Format="{0:n}" ID="colZkNetto" runat="server" EncodeHTML="True"></ea:GridColumn>
					<ea:GridColumn Width="12" Align="Right" Total="Sum" Caption="Zakup~Brutto" Format="{0:n}" ID="colZkBrutto" runat="server" EncodeHTML="True"></ea:GridColumn>
					<ea:GridColumn Width="10" Align="Right" Caption="Cena|jedn./N" Format="{0:n}" ID="colCenaJednostki" runat="server" EncodeHTML="True"></ea:GridColumn>
				</Columns>
			</ea:grid><eb:reportfooter id="ReportFooter" runat="server"></eb:reportfooter></FORM>
	</BODY>
</HTML>

